
import ddf.minim.*;
import processing.video.*;

Capture cam;
PImage mouth;
String[] images = {"mouth.png", "mouth2.jpg"};
int mouthIndex = 0;
Minim minim;
AudioInput in;
float level;

void setup()
{
  size(640, 480, P2D);
  
  mouth = loadImage(images[mouthIndex]);
  
  // camera
  
   String[] cameras = Capture.list();
  
  if (cameras.length == 0) {
    println("There are no cameras available for capture.");
    exit();
  } else {
    println("Available cameras:");
    for (int i = 0; i < cameras.length; i++) {
      println(cameras[i]);
    }
    
    cam = new Capture(this, 640, 480, cameras[0]);
    cam.start();
    
    // You can get the list of resolutions (width x height x fps)  
    // supported capture device by calling the resolutions()
    // method. It must be called after creating the capture 
    // object. 
    Resolution[] res = cam.resolutions();
    println("Supported resolutions:");
    for (int i = 0; i < res.length; i++) { 
      println(res[i].width + "x" + res[i].height + ", " + 
              res[i].fps + " fps (" + res[i].fpsString +")");  
    }        
  }      
  
  
  // end camera
  
  minim = new Minim(this);
  minim.debugOn();
  in = minim.getLineIn(Minim.STEREO, 512);
}

void draw()
{

  stroke(255);

  level = in.mix.level()*512;

  println(level);
  
  if(level > 200) nextMouth(); // add next mouth timer
  
  tint(level);
  
  
  if (cam.available() == true) {
    cam.read();
  }
  image(cam, 0, 0);
  
  //image(mouth, 0, 0);
}

void nextMouth() {
  
  mouthIndex++;
  if(mouthIndex >= images.length) mouthIndex = 0;
  mouth = loadImage(images[mouthIndex]);
  
}


void stop()
{
  in.close();
  minim.stop();
  super.stop();
}

